function [ndata,ndata2,ndata3,ndata4] = savpivots_1v3rnd(data,alldata,ori,termi,ch1,prepost1,ch2,prepost2,ch3,prepost3,fltr3)
%This function is an automated way to extract the pivot list, rotated
%pivot list and pivot properties of a set of classified synapses.  Used to
%be called synpivots.  Pretty much same as savpivots, but this is
%specifically designed for use to compare two classes, meaning if you want
%to find exclusive VGluT1 synapses or VGluT2 synapses.  1v3 is modified so
%we are able to compare three classes, so 1 to 2 and 2 to 3, we will also
%save class 2 to make things more efficient in compuation.  This is
%prompted by the desire to compare VGluT1 and VGluT2 to VGluT1&2 synapses.
%Synatax:   [ndata] = savpivots_1v2(data,ori,termi,ch1,ch2);
%Input:     data = punc_data data structure used for the classification
%           alldata = all_data data structure from punc_locodist
%           ori = the origin or central pivot used for the analysis
%           termi = the termini for the analysis, really only used for the
%                   generation of the rotated pivots
%           ch1 = the first third channel, e.g., VGlut1
%           prepost1 = the prepost parameter for punc_colo_all for ch1
%           ch2 = the second third channel, e.g., VGlut2&3
%           prepost2 = the prepost parameter for punc_colo_all for ch2&3
%           ch3 = the second third channel, e.g., VGlut2
%           prepost3 = the prepost parameter for punc_colo_all for ch2
%           fltr3 = activate filter 3 in punc_colo_all or not
%Output:    ndata = a structure with the fields, pivots, properties, and
%                   summary.  The layers of the structure match the layer
%                   structure of the data.  Note: filename is carried over
%                   from data.
%           ndata2 = ndata for the second set.
%           ndata3 = ndata for the third set.

if nargin<=10    %choose default for fltr3
    fltr3 = 1;  %on
end

filenames = data(1).filenames;  %pull out the channel names
pathnames12 = uigetdir2('','Directory for Unique 1st Dataset');       %get the directory where you want to save into.
pathnames21 = uigetdir2('','Directory for Unique 2nd compared to 1st');       %get the directory where you want to save into.
pathnames32 = uigetdir2('','Directory for Unique 3rd Dataset');       %get the directory where you want to save into.
pathnames23 = uigetdir2('','Directory for Unique 2nd compared to 3rd');       %get the directory where you want to save into.
pathnames2 = uigetdir2('','Directory for 2nd dataset');       %get the directory where you want to save into.
tverts = data(ori).termi;   %grab the terminal vertices
tprops = data(ori).termi_prop;   %grab the terminal properties
tdist = data(ori).distance;     %grab the distance to termi

%lets generate the two classes and the indexes for the two classes.
%           idx = the index of the synaptic subset
%           idx2 = is the indext of the 2nd synaptic subset, i.e., VGluT2&2
%                   if idx is VGluT1.
%           idx3 = VGluT2
%NOTE!: By default here the thrid point is considered closer to the termi
%and is offset by 1, which you will need to change if you decide on
%something differ.
[allidx,idx,adata,neardata] = punc_colo_all(alldata,ori,ch1,'termi',termi,'mod',1,'mod_fltr',1,'pp_fltr',1,'prepost',prepost1,'fltr3',fltr3); %class 1
[allidx2,idx2,adata2,neardata2] = punc_colo_all(alldata,ori,ch2,'termi',termi,'mod',1,'mod_fltr',1,'pp_fltr',1,'prepost',prepost2,'fltr3',fltr3); %class 2
[allidx3,idx3,adata3,neardata3] = punc_colo_all(alldata,ori,ch3,'termi',termi,'mod',1,'mod_fltr',1,'pp_fltr',1,'prepost',prepost3,'fltr3',fltr3); %class 3

%[nd] = savpivots(data,alldata,ori,termi,idx2);  %test save out #2

%Lets find the unique vertices first
c1 = data(ori).vertices;        %grab the ori vertices for the first class(VGluT1)
c1(idx,:) = [];                 %The vertices for class 1
c2 = data(ori).vertices;        %grab the ori vertices for the second class(VGluT1&2)
c2(idx2,:) = [];                %the vertices for class 2
c3 = data(ori).vertices;        %grab the ori vertices for the second class(VGluT2)
c3(idx3,:) = [];                %the vertices for class 3
%compare 1 to 2
[a2b,b2a,ab,vsidx] = unique_verts2(c1,c2);   %find the unique vertices
clear a2b b2a ab
%now pull out the relavent indexs for created the unique lists in the
%classes
uidx = vsidx{1};        %unique index 1 for class 1
uidx21 = vsidx{2};       %unique index 2 for class 2
%compare 3 to 2
[a2b,b2a,ab,vsidx2] = unique_verts2(c3,c2);   %find the unique vertices
clear a2b b2a ab
%now pull out the relavent indexs for created the unique lists in the
%classes
uidx3 = vsidx2{1};        %unique index 3 for class 1
uidx23 = vsidx2{2};       %unique index 2 for class 2to3
%Lets do the same for alldata
c1 = data(ori).vertices;        %grab the ori vertices for the first class(VGluT1)
c1(allidx,:) = [];                 %The vertices for class 1
c2 = data(ori).vertices;        %grab the ori vertices for the second class(VGluT1&2)
c2(allidx2,:) = [];                %the vertices for class 2
c3 = data(ori).vertices;        %grab the ori vertices for the second class(VGluT2)
c3(allidx3,:) = [];                %the vertices for class 3
%compare 1 to 2
[a2b,b2a,ab,vsidx] = unique_verts2(c1,c2);   %find the unique vertices
clear a2b b2a ab
%now pull out the relavent indexs for created the unique lists in the
%classes
auidx = vsidx{1};        %unique index 1 for class 1
auidx21 = vsidx{2};       %unique index 2 for class 2
%compare 3 to 2
[a2b,b2a,ab,vsidx2] = unique_verts2(c3,c2);   %find the unique vertices
clear a2b b2a ab
%now pull out the relavent indexs for created the unique lists in the
%classes
auidx3 = vsidx2{1};        %unique index 3 for class 1
auidx23 = vsidx2{2};       %unique index 2 for class 2to3

h = waitbar(0,'Processing Properties of: ');    %initialize progress bar.
count = [];
acount = [];
aucount = [];
count21 = [];
acount21 = [];
aucount21 = [];
count3 = [];
acount3 = [];
aucount3 = [];
count23 = [];
acount23 = [];
aucount23 = [];
count2 = [];
acount2 = [];
aucount2 = [];
for i = 1:size(filenames,2)     %go through the channels
    %initiate
    sdata = [];
    sdata2 = [];
    sdata3 = [];
    sdata4 = [];
    sdata5 = [];
    %process filename
    strmask = isspace(filenames{i});
    spcloc = find(strmask==1);
    filename = strtrim(filenames{i}(min(spcloc):max(spcloc)));
    celllabels{i} = filename;  %create a cell array of file names to label the count files
    waitbar(i/size(filenames,2),h,['Processing Properties of: ' filename]);   %update progress
    if i==ori   %process for data at the origin
        %get self data (self=ori)
        %process for class 1(VGluT1)
        vert_tmp = cell2mat(neardata(1).vert);
        prop_tmp = cell2mat(neardata(1).oprop);
        %the ori verts are duplicated in the data structure, and I think is
        %unnecessary here, so we are choosing the parsimonenous set.
        avert_tmp = adata(1).vert;
        aprop_tmp = adata(1).oprop;
        vert_tmp = vert_tmp(uidx,:);
        c1 = vert_tmp;           %store this for later use
        prop_tmp = prop_tmp(uidx,:);
        avert_tmp = avert_tmp(auidx,:);
        aprop_tmp = aprop_tmp(auidx,:);
        avert_tmp = cell2mat(avert_tmp);
        aprop_tmp = cell2mat(aprop_tmp);
        %process for class 2(VGluT21)
        vert_tmp2 = cell2mat(neardata2(1).vert);
        prop_tmp2 = cell2mat(neardata2(1).oprop);
        avert_tmp2 = adata2(1).vert;
        aprop_tmp2 = adata2(1).oprop;
        vert_tmp2 = vert_tmp2(uidx21,:);
        d1 = vert_tmp2;           %store this for later use
        prop_tmp2 = prop_tmp2(uidx21,:);
        avert_tmp2 = avert_tmp2(auidx21,:);
        aprop_tmp2 = aprop_tmp2(auidx21,:);
        avert_tmp2 = cell2mat(avert_tmp2);
        aprop_tmp2 = cell2mat(aprop_tmp2);
        %process for class 1(VGluT3)
        vert_tmp3 = cell2mat(neardata3(1).vert);
        prop_tmp3 = cell2mat(neardata3(1).oprop);
        avert_tmp3 = adata3(1).vert;
        aprop_tmp3 = adata3(1).oprop;
        vert_tmp3 = vert_tmp3(uidx3,:);
        c3 = vert_tmp3;           %store this for later use
        prop_tmp3 = prop_tmp3(uidx3,:);
        avert_tmp3 = avert_tmp3(auidx3,:);
        aprop_tmp3 = aprop_tmp3(auidx3,:);
        avert_tmp3 = cell2mat(avert_tmp3);
        aprop_tmp3 = cell2mat(aprop_tmp3);
        %process for class 2(VGluT32)
        vert_tmp4 = cell2mat(neardata2(1).vert);
        prop_tmp4 = cell2mat(neardata2(1).oprop);
        avert_tmp4 = adata2(1).vert;
        aprop_tmp4 = adata2(1).oprop;
        vert_tmp4 = vert_tmp4(uidx23,:);
        d3 = vert_tmp4;           %store this for later use
        prop_tmp4 = prop_tmp4(uidx23,:);
        avert_tmp4 = avert_tmp4(auidx23,:);
        aprop_tmp4 = aprop_tmp4(auidx23,:);
        avert_tmp4 = cell2mat(avert_tmp4);
        aprop_tmp4 = cell2mat(aprop_tmp4);
        %process for class 2(VGluT1&2)
        vert_tmp5 = cell2mat(neardata2(1).vert);
        prop_tmp5 = cell2mat(neardata2(1).oprop);
        avert_tmp5 = adata2(1).vert;
        aprop_tmp5 = adata2(1).oprop;
        e1 = vert_tmp5;           %store this for later use
        avert_tmp5 = cell2mat(avert_tmp5);
        aprop_tmp5 = cell2mat(aprop_tmp5);
    elseif i==termi
        %process for class 1(VGluT1)
        vert_tmp = cell2mat(neardata(1).termi);
        prop_tmp = cell2mat(neardata(1).tprop);
        vert_tmp = vert_tmp(uidx,:);
        c2 = vert_tmp;           %store this for later use
        prop_tmp = prop_tmp(uidx,:);
        avert_tmp = adata(1).termi;
        aprop_tmp = adata(1).tprop;
        avert_tmp = avert_tmp(auidx,:);
        aprop_tmp = aprop_tmp(auidx,:);
        avert_tmp = cell2mat(avert_tmp);
        aprop_tmp = cell2mat(aprop_tmp);
        %process for class 2(VGluT21)
        vert_tmp2 = cell2mat(neardata2(1).termi);
        prop_tmp2 = cell2mat(neardata2(1).tprop);
        vert_tmp2 = vert_tmp2(uidx21,:);
        d2 = vert_tmp2;           %store this for later use
        prop_tmp2 = prop_tmp2(uidx21,:);
        avert_tmp2 = adata2(1).termi;
        aprop_tmp2 = adata2(1).tprop;
        avert_tmp2 = avert_tmp2(auidx21,:);
        aprop_tmp2 = aprop_tmp2(auidx21,:);
        avert_tmp2 = cell2mat(avert_tmp2);
        aprop_tmp2 = cell2mat(aprop_tmp2);
        %process for class 1(VGluT3)
        vert_tmp3 = cell2mat(neardata3(1).termi);
        prop_tmp3 = cell2mat(neardata3(1).tprop);
        vert_tmp3 = vert_tmp3(uidx3,:);
        c4 = vert_tmp3;           %store this for later use
        prop_tmp3 = prop_tmp3(uidx3,:);
        avert_tmp3 = adata3(1).termi;
        aprop_tmp3 = adata3(1).tprop;
        avert_tmp3 = avert_tmp3(auidx3,:);
        aprop_tmp3 = aprop_tmp3(auidx3,:);
        avert_tmp3 = cell2mat(avert_tmp3);
        aprop_tmp3 = cell2mat(aprop_tmp3);
        %process for class 2(VGluT32)
        vert_tmp4 = cell2mat(neardata2(1).termi);
        prop_tmp4 = cell2mat(neardata2(1).tprop);
        vert_tmp4 = vert_tmp4(uidx23,:);
        d4 = vert_tmp4;           %store this for later use
        prop_tmp4 = prop_tmp4(uidx23,:);
        avert_tmp4 = adata2(1).termi;
        aprop_tmp4 = adata2(1).tprop;
        avert_tmp4 = avert_tmp4(auidx23,:);
        aprop_tmp4 = aprop_tmp4(auidx23,:);
        avert_tmp4 = cell2mat(avert_tmp4);
        aprop_tmp4 = cell2mat(aprop_tmp4);
        %process for class 2(VGluT1&2)
        vert_tmp5 = cell2mat(neardata2(1).termi);
        prop_tmp5 = cell2mat(neardata2(1).tprop);
        e2 = vert_tmp5;           %store this for later use
        avert_tmp5 = cell2mat(adata2(1).termi);
        aprop_tmp5 = cell2mat(adata2(1).tprop);
    elseif max(i==ch1)||max(i==ch2)||max(i==ch3)  %the third channel
        %process for class 1(VGluT1)
        if max(i==ch1) %is part of the first class
            curr_chan = find(ch1==i);   %get the location in the data structure where the channel is.
            vert_tmp = cell2mat(neardata(curr_chan).third);
            prop_tmp = cell2mat(neardata(curr_chan).thirdprop);
            vert_tmp = vert_tmp(uidx,:);
            prop_tmp = prop_tmp(uidx,:);
            avert_tmp = adata(curr_chan).third;
            aprop_tmp = adata(curr_chan).thirdprop;
            avert_tmp = avert_tmp(auidx,:);
            aprop_tmp = aprop_tmp(auidx,:);
            avert_tmp = cell2mat(avert_tmp);
            aprop_tmp = cell2mat(aprop_tmp);
        else        %if max(i~=ch2)&&max(i~=ch3) %but not part of the second class
            vert_tmp = tverts(:,:,i);    %all ori vertices
            vert_tmp(idx,:) = [];             %all relavent vertices
            vert_tmp = vert_tmp(uidx,:);    %unique
            vert_tmp(isnan(vert_tmp(:,1)),:) = [];  %remove nan lines
            prop_tmp = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
            prop_tmp(idx,:) = [];         %all of the relavent vertices
            prop_tmp = prop_tmp(uidx,:);    %unique
            prop_tmp(isnan(prop_tmp(:,1)),:) = [];   %remove nan lines
            %all data time
            avert_tmp = tverts(:,:,i);    %all ori vertices
            avert_tmp(allidx,:) = [];             %all relavent vertices
            avert_tmp = avert_tmp(auidx,:);    %unique
            avert_tmp(isnan(avert_tmp(:,1)),:) = [];  %remove nan lines
            aprop_tmp = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
            aprop_tmp(allidx,:) = [];         %all of the relavent vertices
            aprop_tmp = aprop_tmp(auidx,:);    %unique
            aprop_tmp(isnan(aprop_tmp(:,1)),:) = [];   %remove nan lines
        end
        %process for class 2(VGluT21)
        vert_tmp2 = tverts(:,:,i);    %all ori vertices
        vert_tmp2(idx2,:) = [];             %all relavent vertices
        vert_tmp2 = vert_tmp2(uidx21,:);    %unique
        vert_tmp2(isnan(vert_tmp2(:,1)),:) = [];  %remove nan lines
        prop_tmp2 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        prop_tmp2(idx2,:) = [];         %all of the relavent vertices
        prop_tmp2 = prop_tmp2(uidx21,:);    %unique
        prop_tmp2(isnan(prop_tmp2(:,1)),:) = [];   %remove nan lines
        %alldata
        avert_tmp2 = tverts(:,:,i);    %all ori vertices
        avert_tmp2(allidx2,:) = [];             %all relavent vertices
        avert_tmp2 = avert_tmp2(auidx21,:);    %unique
        avert_tmp2(isnan(avert_tmp2(:,1)),:) = [];  %remove nan lines
        aprop_tmp2 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        aprop_tmp2(allidx2,:) = [];         %all of the relavent vertices
        aprop_tmp2 = aprop_tmp2(auidx21,:);    %unique
        %process for class 1(VGluT3)
        if max(i==ch3) %is part of the first class
            curr_chan = find(ch3==i);   %get the location in the data structure where the channel is.
            vert_tmp3 = cell2mat(neardata3(curr_chan).third);
            prop_tmp3 = cell2mat(neardata3(curr_chan).thirdprop);
            vert_tmp3 = vert_tmp3(uidx3,:);
            prop_tmp3 = prop_tmp3(uidx3,:);
            avert_tmp3 = adata3(curr_chan).third;
            aprop_tmp3 = adata3(curr_chan).thirdprop;
            avert_tmp3 = avert_tmp3(auidx3,:);
            aprop_tmp3 = aprop_tmp3(auidx3,:);
            avert_tmp3 = cell2mat(avert_tmp3);
            aprop_tmp3 = cell2mat(aprop_tmp3);
        else    %if max(i~=ch1)&&max(i~=ch2) %but not part of the second class
            vert_tmp3 = tverts(:,:,i);    %all ori vertices
            vert_tmp3(idx3,:) = [];             %all relavent vertices
            vert_tmp3 = vert_tmp3(uidx3,:);    %unique
            vert_tmp3(isnan(vert_tmp3(:,1)),:) = [];  %remove nan lines
            prop_tmp3 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
            prop_tmp3(idx3,:) = [];         %all of the relavent vertices
            prop_tmp3 = prop_tmp3(uidx3,:);    %unique
            prop_tmp3(isnan(prop_tmp3(:,1)),:) = [];   %remove nan lines
            %all data time
            avert_tmp3 = tverts(:,:,i);    %all ori vertices
            avert_tmp3(allidx3,:) = [];             %all relavent vertices
            avert_tmp3 = avert_tmp3(auidx3,:);    %unique
            avert_tmp3(isnan(avert_tmp3(:,1)),:) = [];  %remove nan lines
            aprop_tmp3 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
            aprop_tmp3(allidx3,:) = [];         %all of the relavent vertices
            aprop_tmp3 = aprop_tmp3(auidx3,:);    %unique
            aprop_tmp3(isnan(aprop_tmp3(:,1)),:) = [];   %remove nan lines
        end
        %process for class 2(VGluT32)
        vert_tmp4 = tverts(:,:,i);    %all ori vertices
        vert_tmp4(idx2,:) = [];             %all relavent vertices
        vert_tmp4 = vert_tmp4(uidx23,:);    %unique
        vert_tmp4(isnan(vert_tmp4(:,1)),:) = [];  %remove nan lines
        prop_tmp4 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        prop_tmp4(idx2,:) = [];         %all of the relavent vertices
        prop_tmp4 = prop_tmp4(uidx23,:);    %unique
        prop_tmp4(isnan(prop_tmp4(:,1)),:) = [];   %remove nan lines
        %alldata
        avert_tmp4 = tverts(:,:,i);    %all ori vertices
        avert_tmp4(allidx2,:) = [];             %all relavent vertices
        avert_tmp4 = avert_tmp4(auidx23,:);    %unique
        avert_tmp4(isnan(avert_tmp4(:,1)),:) = [];  %remove nan lines
        aprop_tmp4 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        aprop_tmp4(allidx2,:) = [];         %all of the relavent vertices
        aprop_tmp4 = aprop_tmp4(auidx23,:);    %unique
        aprop_tmp4(isnan(aprop_tmp4(:,1)),:) = [];   %remove nan lines
        %process for class 2(VGluT1&2)
        if max(i==ch2) %part of the second class
            curr_chan = find(ch2==i);   %get the location in the data structure where the channel is.
            vert_tmp5 = cell2mat(neardata2(curr_chan).third);
            prop_tmp5 = cell2mat(neardata2(curr_chan).thirdprop);
            avert_tmp5 = adata2(curr_chan).third;
            aprop_tmp5 = adata2(curr_chan).thirdprop;
            avert_tmp5 = cell2mat(avert_tmp5);
            aprop_tmp5 = cell2mat(aprop_tmp5);
        else    %if max(i~=ch1)&&max(i~=ch3) %but not part of the first class
            %process for class 2(VGluT2)
            vert_tmp5 = tverts(:,:,i);    %all ori vertices
            vert_tmp5(idx2,:) = [];             %all relavent vertices
            vert_tmp5(isnan(vert_tmp5(:,1)),:) = [];  %remove nan lines
            prop_tmp5 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
            prop_tmp5(idx2,:) = [];         %all of the relavent vertices
            prop_tmp5(isnan(prop_tmp5(:,1)),:) = [];   %remove nan lines
            %all data time
            avert_tmp5 = tverts(:,:,i);    %all ori vertices
            avert_tmp5(allidx2,:) = [];             %all relavent vertices
            avert_tmp5(isnan(avert_tmp5(:,1)),:) = [];  %remove nan lines
            aprop_tmp5 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
            aprop_tmp5(allidx2,:) = [];         %all of the relavent vertices
            aprop_tmp5(isnan(aprop_tmp5(:,1)),:) = [];   %remove nan lines
        end
    else        %not the origin
        %process for class 1(VGluT1)
        vert_tmp = tverts(:,:,i);    %all ori vertices
        vert_tmp(idx,:) = [];             %all relavent vertices
        vert_tmp = vert_tmp(uidx,:);    %unique
        vert_tmp(isnan(vert_tmp(:,1)),:) = [];  %remove nan lines
        prop_tmp = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        prop_tmp(idx,:) = [];         %all of the relavent vertices
        prop_tmp = prop_tmp(uidx,:);    %unique
        prop_tmp(isnan(prop_tmp(:,1)),:) = [];   %remove nan lines
        %alldata
        avert_tmp = tverts(:,:,i);    %all ori vertices
        avert_tmp(allidx,:) = [];             %all relavent vertices
        avert_tmp = avert_tmp(auidx,:);    %unique
        avert_tmp(isnan(avert_tmp(:,1)),:) = [];  %remove nan lines
        aprop_tmp = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        aprop_tmp(allidx,:) = [];         %all of the relavent vertices
        aprop_tmp = aprop_tmp(auidx,:);    %unique
        aprop_tmp(isnan(aprop_tmp(:,1)),:) = [];   %remove nan lines
        %process for class 2(VGluT21)
        vert_tmp2 = tverts(:,:,i);    %all ori vertices
        vert_tmp2(idx2,:) = [];             %all relavent vertices
        vert_tmp2 = vert_tmp2(uidx21,:);    %unique
        vert_tmp2(isnan(vert_tmp2(:,1)),:) = [];  %remove nan lines
        prop_tmp2 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        prop_tmp2(idx2,:) = [];         %all of the relavent vertices
        prop_tmp2 = prop_tmp2(uidx21,:);    %unique
        prop_tmp2(isnan(prop_tmp2(:,1)),:) = [];   %remove nan lines
        %alldata
        avert_tmp2 = tverts(:,:,i);    %all ori vertices
        avert_tmp2(allidx2,:) = [];             %all relavent vertices
        avert_tmp2 = avert_tmp2(auidx21,:);    %unique
        avert_tmp2(isnan(avert_tmp2(:,1)),:) = [];  %remove nan lines
        aprop_tmp2 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        aprop_tmp2(allidx2,:) = [];         %all of the relavent vertices
        aprop_tmp2 = aprop_tmp2(auidx21,:);    %unique
        %process for class 1(VGluT3)
        vert_tmp3 = tverts(:,:,i);    %all ori vertices
        vert_tmp3(idx3,:) = [];             %all relavent vertices
        vert_tmp3 = vert_tmp3(uidx3,:);    %unique
        vert_tmp3(isnan(vert_tmp3(:,1)),:) = [];  %remove nan lines
        prop_tmp3 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        prop_tmp3(idx3,:) = [];         %all of the relavent vertices
        prop_tmp3 = prop_tmp3(uidx3,:);    %unique
        prop_tmp3(isnan(prop_tmp3(:,1)),:) = [];   %remove nan lines
        %alldata
        avert_tmp3 = tverts(:,:,i);    %all ori vertices
        avert_tmp3(allidx3,:) = [];             %all relavent vertices
        avert_tmp3 = avert_tmp3(auidx3,:);    %unique
        avert_tmp3(isnan(avert_tmp3(:,1)),:) = [];  %remove nan lines
        aprop_tmp3 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        aprop_tmp3(allidx3,:) = [];         %all of the relavent vertices
        aprop_tmp3 = aprop_tmp3(auidx3,:);    %unique
        aprop_tmp3(isnan(aprop_tmp3(:,1)),:) = [];   %remove nan lines
        %process for class 2(VGluT23)
        vert_tmp4 = tverts(:,:,i);    %all ori vertices
        vert_tmp4(idx2,:) = [];             %all relavent vertices
        vert_tmp4 = vert_tmp4(uidx23,:);    %unique
        vert_tmp4(isnan(vert_tmp4(:,1)),:) = [];  %remove nan lines
        prop_tmp4 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        prop_tmp4(idx2,:) = [];         %all of the relavent vertices
        prop_tmp4 = prop_tmp4(uidx23,:);    %unique
        prop_tmp4(isnan(prop_tmp4(:,1)),:) = [];   %remove nan lines
        %alldata
        avert_tmp4 = tverts(:,:,i);    %all ori vertices
        avert_tmp4(allidx2,:) = [];             %all relavent vertices
        avert_tmp4 = avert_tmp4(auidx23,:);    %unique
        avert_tmp4(isnan(avert_tmp4(:,1)),:) = [];  %remove nan lines
        aprop_tmp4 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        aprop_tmp4(allidx2,:) = [];         %all of the relavent vertices
        aprop_tmp4 = aprop_tmp4(auidx23,:);    %unique
        aprop_tmp4(isnan(aprop_tmp4(:,1)),:) = [];   %remove nan lines
        %process for class 2(VGluT1&2)
        vert_tmp5 = tverts(:,:,i);    %all ori vertices
        vert_tmp5(idx2,:) = [];             %all relavent vertices
        vert_tmp5(isnan(vert_tmp5(:,1)),:) = [];  %remove nan lines
        prop_tmp5 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        prop_tmp5(idx2,:) = [];         %all of the relavent vertices
        prop_tmp5(isnan(prop_tmp5(:,1)),:) = [];   %remove nan lines
        %alldata
        avert_tmp5 = tverts(:,:,i);    %all ori vertices
        avert_tmp5(allidx2,:) = [];             %all relavent vertices
        avert_tmp5(isnan(avert_tmp5(:,1)),:) = [];  %remove nan lines
        aprop_tmp5 = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        aprop_tmp5(allidx2,:) = [];         %all of the relavent vertices
        aprop_tmp5(isnan(aprop_tmp5(:,1)),:) = [];   %remove nan lines
    end
    %generate the dataset for the count numbers
    count = [count size(vert_tmp,1)];   %get the number of vertices for each channel
    acount = [acount size(avert_tmp,1)];    %do the same for the all data
    aucount = [aucount size(unique(avert_tmp,'rows'),1)];   %get the unique count from all data
    count21 = [count21 size(vert_tmp2,1)];   %get the number of vertices for each channel
    acount21 = [acount21 size(avert_tmp2,1)];    %do the same for the all data
    aucount21 = [aucount21 size(unique(avert_tmp2,'rows'),1)];   %get the unique count from all data
    count3 = [count3 size(vert_tmp3,1)];   %get the number of vertices for each channel
    acount3 = [acount3 size(avert_tmp3,1)];    %do the same for the all data
    aucount3 = [aucount3 size(unique(avert_tmp3,'rows'),1)];   %get the unique count from all data
    count23 = [count23 size(vert_tmp4,1)];   %get the number of vertices for each channel
    acount23 = [acount23 size(avert_tmp4,1)];    %do the same for the all data
    aucount23 = [aucount23 size(unique(avert_tmp4,'rows'),1)];   %get the unique count from all data
    count2 = [count2 size(vert_tmp5,1)];   %get the number of vertices for each channel
    acount2 = [acount2 size(avert_tmp5,1)];    %do the same for the all data
    aucount2 = [aucount2 size(unique(avert_tmp5,'rows'),1)];   %get the unique count from all data
    %calculate the summary data
    %no outliers
    %Class1
    out = median(prop_tmp(:,2))+std(prop_tmp(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(prop_tmp(:,2)>out);        %find the outliers.
    prop_cache = prop_tmp;  %we want the prop to match the vert output
    prop_cache(x,:) = [];             %remove the outliers
    sdata(1,:) = mean(prop_cache);
    sdata(2,:) = std(prop_cache);
    sdata(3,:) = size(prop_cache,1);
    sdata(4,:) = median(prop_cache);
    %alldata
    %for the property calculation we are going to make this a little more
    %parsimonious using fltr3
    if fltr3>=1
        [cache,fltr3_idx] = unique(avert_tmp,'rows');   %figure out the duplicated vertices
        aprop_tmp = aprop_tmp(fltr3_idx,:);     %unique properties
    end
    if size(aprop_tmp,2)==0     %if the cell in the begining was gutted completely
        %aprop_tmp = zeros(1,2); %fill it with zero
        aprop_tmp = prop_tmp;   %borrow the dataset
        aprop_tmp(:,:) = [];    %empty it.
    end
    out = median(aprop_tmp(:,2))+std(aprop_tmp(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(aprop_tmp(:,2)>out);        %find the outliers.
    aprop_cache = aprop_tmp;
    aprop_cache(x,:) = [];             %remove the outliers
    asdata(1,:) = mean(aprop_cache);
    asdata(2,:) = std(aprop_cache);
    asdata(3,:) = size(aprop_cache,1);
    asdata(4,:) = median(aprop_cache);
    %Class21
    out = median(prop_tmp2(:,2))+std(prop_tmp2(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(prop_tmp2(:,2)>out);        %find the outliers.
    prop_cache2 = prop_tmp2;
    prop_cache2(x,:) = [];             %remove the outliers
    sdata2(1,:) = mean(prop_cache2);
    sdata2(2,:) = std(prop_cache2);
    sdata2(3,:) = size(prop_cache2,1);
    sdata2(4,:) = median(prop_cache2);
    %alldata
    %for the property calculation we are going to make this a little more
    %parsimonious using fltr3
    if fltr3>=1
        [cache,fltr3_idx] = unique(avert_tmp2,'rows');   %figure out the duplicated vertices
        aprop_tmp2 = aprop_tmp2(fltr3_idx,:);     %unique properties
    end
    if size(aprop_tmp2,2)==0     %if the cell in the begining was gutted completely
        %aprop_tmp2 = zeros(1,2); %fill it with zero
        aprop_tmp2 = prop_tmp;   %borrow the dataset
        aprop_tmp2(:,:) = [];    %empty it.
    end
    out = median(aprop_tmp2(:,2))+std(aprop_tmp2(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(aprop_tmp2(:,2)>out);        %find the outliers.
    aprop_cache2 = aprop_tmp2;
    aprop_cache2(x,:) = [];             %remove the outliers
    asdata2(1,:) = mean(aprop_cache2);
    asdata2(2,:) = std(aprop_cache2);
    asdata2(3,:) = size(aprop_cache2,1);
    asdata2(4,:) = median(aprop_cache2);
    %Class3
    out = median(prop_tmp3(:,2))+std(prop_tmp3(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(prop_tmp3(:,2)>out);        %find the outliers.
    prop_cache3 = prop_tmp3;
    prop_cache3(x,:) = [];             %remove the outliers
    sdata3(1,:) = mean(prop_cache3);
    sdata3(2,:) = std(prop_cache3);
    sdata3(3,:) = size(prop_cache3,1);
    sdata3(4,:) = median(prop_cache3);
    %alldata
    %for the property calculation we are going to make this a little more
    %parsimonious using fltr3
    if fltr3>=1
        [cache,fltr3_idx] = unique(avert_tmp3,'rows');   %figure out the duplicated vertices
        aprop_tmp3 = aprop_tmp3(fltr3_idx,:);     %unique properties
    end
    if size(aprop_tmp3,2)==0     %if the cell in the begining was gutted completely
        %aprop_tmp3 = zeros(1,2); %fill it with zero
        aprop_tmp3 = prop_tmp;   %borrow the dataset
        aprop_tmp3(:,:) = [];    %empty it.
    end
    out = median(aprop_tmp3(:,2))+std(aprop_tmp3(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(aprop_tmp3(:,2)>out);        %find the outliers.
    aprop_cache3 = aprop_tmp3;
    aprop_cache3(x,:) = [];             %remove the outliers
    asdata3(1,:) = mean(aprop_cache3);
    asdata3(2,:) = std(aprop_cache3);
    asdata3(3,:) = size(aprop_cache3,1);
    asdata3(4,:) = median(aprop_cache3);
    %Class23
    out = median(prop_tmp4(:,2))+std(prop_tmp4(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(prop_tmp4(:,2)>out);        %find the outliers.
    prop_cache4 = prop_tmp4;
    prop_cache4(x,:) = [];             %remove the outliers
    sdata4(1,:) = mean(prop_cache4);
    sdata4(2,:) = std(prop_cache4);
    sdata4(3,:) = size(prop_cache4,1);
    sdata4(4,:) = median(prop_cache4);
    %alldata
    %for the property calculation we are going to make this a little more
    %parsimonious using fltr3
    if fltr3>=1
        [cache,fltr3_idx] = unique(avert_tmp4,'rows');   %figure out the duplicated vertices
        aprop_tmp4 = aprop_tmp4(fltr3_idx,:);     %unique properties
    end
    if size(aprop_tmp4,2)==0     %if the cell in the begining was gutted completely
        %aprop_tmp4 = zeros(1,2); %fill it with zero
        aprop_tmp4 = prop_tmp;   %borrow the dataset
        aprop_tmp4(:,:) = [];    %empty it.
    end
    out = median(aprop_tmp4(:,2))+std(aprop_tmp4(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(aprop_tmp4(:,2)>out);        %find the outliers.
    aprop_cache4 = aprop_tmp4;
    aprop_cache4(x,:) = [];             %remove the outliers
    asdata4(1,:) = mean(aprop_cache4);
    asdata4(2,:) = std(aprop_cache4);
    asdata4(3,:) = size(aprop_cache4,1);
    asdata4(4,:) = median(aprop_cache4);
    %Class1&2
    out = median(prop_tmp5(:,2))+std(prop_tmp5(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(prop_tmp5(:,2)>out);        %find the outliers.
    prop_cache5 = prop_tmp5;
    prop_cache5(x,:) = [];             %remove the outliers
    sdata5(1,:) = mean(prop_cache5);
    sdata5(2,:) = std(prop_cache5);
    sdata5(3,:) = size(prop_cache5,1);
    sdata5(4,:) = median(prop_cache5);
    %alldata
    %for the property calculation we are going to make this a little more
    %parsimonious using fltr3
    if fltr3>=1
        [cache,fltr3_idx] = unique(avert_tmp5,'rows');   %figure out the duplicated vertices
        aprop_tmp5 = aprop_tmp5(fltr3_idx,:);     %unique properties
    end
    if size(aprop_tmp5,2)==0     %if the cell in the begining was gutted completely
        %aprop_tmp5 = zeros(1,2); %fill it with zero
        aprop_tmp5 = prop_tmp;   %borrow the dataset
        aprop_tmp5(:,:) = [];    %empty it.
    end
    out = median(aprop_tmp5(:,2))+std(aprop_tmp5(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(aprop_tmp5(:,2)>out);        %find the outliers.
    aprop_cache5 = aprop_tmp5;
    aprop_cache5(x,:) = [];             %remove the outliers
    asdata5(1,:) = mean(aprop_cache5);
    asdata5(2,:) = std(aprop_cache5);
    asdata5(3,:) = size(aprop_cache5,1);
    asdata5(4,:) = median(aprop_cache5);
    %save the ori data
    %Class1
    sav2csv(vert_tmp,['vert_',filename,'_',num2str(size(vert_tmp,1))],pathnames12);    %save the vertices
    sav2csv(prop_tmp,['prop_',filename],pathnames12);     %save the properties
    sav2csv(sdata,['sum_',filename],pathnames12);     %save the properties
    sav2csv(avert_tmp,['avert_',filename,'_',num2str(size(avert_tmp,1))],pathnames12);    %save the vertices
    sav2csv(aprop_tmp,['aprop_',filename],pathnames12);     %save the properties
    sav2csv(asdata,['asum_',filename],pathnames12);     %save the properties
    %Class21
    sav2csv(vert_tmp2,['vert_',filename,'_',num2str(size(vert_tmp2,1))],pathnames21);    %save the vertices
    sav2csv(prop_tmp2,['prop_',filename],pathnames21);     %save the properties
    sav2csv(sdata2,['sum_',filename],pathnames21);     %save the properties
    sav2csv(avert_tmp2,['avert_',filename,'_',num2str(size(avert_tmp2,1))],pathnames21);    %save the vertices
    sav2csv(aprop_tmp2,['aprop_',filename],pathnames21);     %save the properties
    sav2csv(asdata2,['asum_',filename],pathnames21);     %save the properties
    %Class3
    sav2csv(vert_tmp3,['vert_',filename,'_',num2str(size(vert_tmp3,1))],pathnames32);    %save the vertices
    sav2csv(prop_tmp3,['prop_',filename],pathnames32);     %save the properties
    sav2csv(sdata3,['sum_',filename],pathnames32);     %save the properties
    sav2csv(avert_tmp3,['avert_',filename,'_',num2str(size(avert_tmp3,1))],pathnames32);    %save the vertices
    sav2csv(aprop_tmp3,['aprop_',filename],pathnames32);     %save the properties
    sav2csv(asdata3,['asum_',filename],pathnames32);     %save the properties
    %Class23
    sav2csv(vert_tmp4,['vert_',filename,'_',num2str(size(vert_tmp4,1))],pathnames23);    %save the vertices
    sav2csv(prop_tmp4,['prop_',filename],pathnames23);     %save the properties
    sav2csv(sdata4,['sum_',filename],pathnames23);     %save the properties
    sav2csv(avert_tmp4,['avert_',filename,'_',num2str(size(avert_tmp4,1))],pathnames23);    %save the vertices
    sav2csv(aprop_tmp4,['aprop_',filename],pathnames23);     %save the properties
    sav2csv(asdata4,['asum_',filename],pathnames23);     %save the properties
    %Class1&2
    sav2csv(vert_tmp5,['vert_',filename,'_',num2str(size(vert_tmp5,1))],pathnames2);    %save the vertices
    sav2csv(prop_tmp5,['prop_',filename],pathnames2);     %save the properties
    sav2csv(sdata5,['sum_',filename],pathnames2);     %save the properties
    sav2csv(avert_tmp5,['avert_',filename,'_',num2str(size(avert_tmp5,1))],pathnames2);    %save the vertices
    sav2csv(aprop_tmp5,['aprop_',filename],pathnames2);     %save the properties
    sav2csv(asdata5,['asum_',filename],pathnames2);     %save the properties
    %store to ndata
    %Class1
    ndata(i).pivots = vert_tmp;
    ndata(i).props = prop_tmp;
    ndata(i).sum = sdata;
    ndata(i).apivots = avert_tmp;
    ndata(i).aprops = aprop_tmp;
    ndata(i).asum = asdata;
    %Class21
    ndata2(i).pivots = vert_tmp2;
    ndata2(i).props = prop_tmp2;
    ndata2(i).sum = sdata2;
    ndata2(i).apivots = avert_tmp2;
    ndata2(i).aprops = aprop_tmp2;
    ndata2(i).asum = asdata2;
    %Class3
    ndata3(i).pivots = vert_tmp3;
    ndata3(i).props = prop_tmp3;
    ndata3(i).sum = sdata3;
    ndata3(i).apivots = avert_tmp3;
    ndata3(i).aprops = aprop_tmp3;
    ndata3(i).asum = asdata3;
    %Class23
    ndata4(i).pivots = vert_tmp4;
    ndata4(i).props = prop_tmp4;
    ndata4(i).sum = sdata4;
    ndata4(i).apivots = avert_tmp4;
    ndata4(i).aprops = aprop_tmp4;
    ndata4(i).asum = asdata4;
    %Class1&2
    ndata5(i).pivots = vert_tmp5;
    ndata5(i).props = prop_tmp5;
    ndata5(i).sum = sdata5;
    ndata5(i).apivots = avert_tmp5;
    ndata5(i).aprops = aprop_tmp5;
    ndata5(i).asum = asdata5;
end
%now finish saving the count data
data_tmp = dataset(count','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'count_summary.csv',pathnames12);
data_tmp = dataset(acount','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'allcount_summary.csv',pathnames12);
data_tmp = dataset(aucount','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'alluniquecount_summary.csv',pathnames12);
%#2
data_tmp = dataset(count2','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'count_summary2.csv',pathnames2);
data_tmp = dataset(acount2','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'allcount_summary2.csv',pathnames2);
data_tmp = dataset(aucount2','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'alluniquecount_summary2.csv',pathnames2);
%#3
data_tmp = dataset(count3','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'count_summary3.csv',pathnames32);
data_tmp = dataset(acount3','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'allcount_summary3.csv',pathnames32);
data_tmp = dataset(aucount3','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'alluniquecount_summary3.csv',pathnames32);
%#21
data_tmp = dataset(count21','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'count_summary21.csv',pathnames21);
data_tmp = dataset(acount21','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'allcount_summary21.csv',pathnames21);
data_tmp = dataset(aucount21','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'alluniquecount_summary21.csv',pathnames21);
%#23
data_tmp = dataset(count23','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'count_summary23.csv',pathnames23);
data_tmp = dataset(acount23','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'allcount_summary23.csv',pathnames23);
data_tmp = dataset(aucount23','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'alluniquecount_summary23.csv',pathnames23);
close(h);   %close progress bar

%now get the rotated vertices
t_out = [];     %initiate
t_out2 = [];
t_out3 = [];
t_out4 = [];
t_out5 = [];
at_out = [];     %initiate
at_out2 = [];
at_out3 = [];
at_out4 = [];
at_out5 = [];
h1 = waitbar(0,'Rotating Vertices of: ');    %initialize progress bar
parpool      %lets go massive
for j = 1:size(filenames,2)
    if j~=ori && j~=termi
        %process filename
        strmask = isspace(filenames{j});
        spcloc = find(strmask==1);
        filename = strtrim(filenames{j}(min(spcloc):max(spcloc)));
        waitbar(j/size(filenames,2),h1,['Rotating Vertices of: ' filename]);   %update progress
        third = alldata(ori).all_termi(:,:,j);     %get the third point
        %Class1
        if ~isempty(uidx)
            [chan,t_tmp] = syn_align_loco(c1,c2,third);
            [chan1] = flat_verts(chan);
            sav2csv(chan,['3Dvert_',filename],pathnames12);
            sav2csv(chan1,['flat_',filename],pathnames12);
            t_out = vertcat(t_out,t_tmp);
            %save to ndata
            ndata(j).rotpivots = chan;
            ndata(j).flatpivots = chan1;
        end
        %Class21
        if ~isempty(uidx21)
            [chan,t_tmp] = syn_align_loco(d1,d2,third);
            [chan1] = flat_verts(chan);
            sav2csv(chan,['3Dvert_',filename],pathnames21);
            sav2csv(chan1,['flat_',filename],pathnames21);
            t_out2 = vertcat(t_out2,t_tmp);
            %save to ndata
            ndata2(j).rotpivots = chan;
            ndata2(j).flatpivots = chan1;
        end
        %Class32
        if ~isempty(uidx3)
            [chan,t_tmp] = syn_align_loco(c3,c4,third);
            [chan1] = flat_verts(chan);
            sav2csv(chan,['3Dvert_',filename],pathnames32);
            sav2csv(chan1,['flat_',filename],pathnames32);
            t_out3 = vertcat(t_out3,t_tmp);
            %save to ndata
            ndata3(j).rotpivots = chan;
            ndata3(j).flatpivots = chan1;
        end
        %Class23
        if ~isempty(uidx23)
            [chan,t_tmp] = syn_align_loco(d3,d4,third);
            [chan1] = flat_verts(chan);
            sav2csv(chan,['3Dvert_',filename],pathnames23);
            sav2csv(chan1,['flat_',filename],pathnames23);
            t_out4 = vertcat(t_out4,t_tmp);
            %save to ndata
            ndata4(j).rotpivots = chan;
            ndata4(j).flatpivots = chan1;
        end
        %Class1&2
        if ~isempty(idx2)
            [chan,t_tmp] = syn_align_loco(e1,e2,third);
            [chan1] = flat_verts(chan);
            sav2csv(chan,['3Dvert_',filename],pathnames2);
            sav2csv(chan1,['flat_',filename],pathnames2);
            t_out5 = vertcat(t_out5,t_tmp);
            %save to ndata
            ndata5(j).rotpivots = chan;
            ndata5(j).flatpivots = chan1;
        end
        %alldata
        %Class1
        if ~isempty(auidx)
            ac1 = adata(1).vert;
            ac1 = ac1(auidx,:);
            ac2 = adata(1).termi;
            ac2 = ac2(auidx,:);
            ac_tmp = unique([cell2mat(ac1) cell2mat(ac2)],'rows');  %pick the unique ori termi pairs
            ac1 = ac_tmp(:,1:4);   %grab the vertices with ordinals
            ac2 = ac_tmp(:,5:7);  %grab the termi vertices
            [chan,t_tmp] = syn_align_loco(ac1,ac2,third);
            [chan1] = flat_verts(chan);
            sav2csv(chan,['a3Dvert_',filename],pathnames12);
            sav2csv(chan1,['aflat_',filename],pathnames12);
            at_out = vertcat(at_out,t_tmp);
            %save to ndata
            ndata(j).arotpivots = chan;
            ndata(j).aflatpivots = chan1;
        end
        %Class21
        if ~isempty(auidx21)
            ad1 = adata2(1).vert;
            ad1 = ad1(auidx21,:);
            ad2 = adata2(1).termi;
            ad2 = ad2(auidx21,:);
            ad_tmp = unique([cell2mat(ad1) cell2mat(ad2)],'rows');  %pick the unique ori termi pairs
            ad1 = ac_tmp(:,1:4);   %grab the vertices with ordinals
            ad2 = ac_tmp(:,5:7);  %grab the termi vertices
            [chan,t_tmp] = syn_align_loco(ad1,ad2,third);
            [chan1] = flat_verts(chan);
            sav2csv(chan,['a3Dvert_',filename],pathnames21);
            sav2csv(chan1,['aflat_',filename],pathnames21);
            at_out2 = vertcat(at_out2,t_tmp);
            %save to ndata
            ndata2(j).arotpivots = chan;
            ndata2(j).aflatpivots = chan1;
        end
        %Class32
        if ~isempty(auidx3)
            ac3 = adata3(1).vert;
            ac3 = ac3(auidx3,:);
            ac4 = adata3(1).termi;
            ac4 = ac4(auidx3,:);
            ac2_tmp = unique([cell2mat(ac3) cell2mat(ac4)],'rows');
            ac3 = ac2_tmp(:,1:4);   %grab the vertices with ordinals
            ac4 = ac2_tmp(:,5:7);  %grab the termi vertices
            [chan,t_tmp] = syn_align_loco(ac3,ac4,third);
            [chan1] = flat_verts(chan);
            sav2csv(chan,['a3Dvert_',filename],pathnames32);
            sav2csv(chan1,['aflat_',filename],pathnames32);
            at_out3 = vertcat(at_out3,t_tmp);
            %save to ndata
            ndata3(j).arotpivots = chan;
            ndata3(j).aflatpivots = chan1;
        end
        %Class23
        if ~isempty(auidx23)
            ad3 = adata2(1).vert;
            ad3 = ad3(auidx23,:);
            ad4 = adata2(1).termi;
            ad4 = ad4(auidx23,:);
            ad2_tmp = unique([cell2mat(ad3) cell2mat(ad4)],'rows');
            ad3 = ad2_tmp(:,1:4);   %grab the vertices with ordinals
            ad4 = ad2_tmp(:,5:7);  %grab the termi vertices
            [chan,t_tmp] = syn_align_loco(ad3,ad4,third);
            [chan1] = flat_verts(chan);
            sav2csv(chan,['a3Dvert_',filename],pathnames23);
            sav2csv(chan1,['aflat_',filename],pathnames23);
            at_out4 = vertcat(at_out4,t_tmp);
            %save to ndata
            ndata4(j).arotpivots = chan;
            ndata4(j).aflatpivots = chan1;
        end
        %Class1&2
        if ~isempty(allidx2)
            ae_tmp = unique([cell2mat(adata2(1).vert) cell2mat(adata2(1).termi)],'rows');
            ae1 = ae_tmp(:,1:4);   %grab the vertices with ordinals
            ae2 = ae_tmp(:,5:7);  %grab the termi vertices
            [chan,t_tmp] = syn_align_loco(ae1,ae2,third);
            [chan1] = flat_verts(chan);
            sav2csv(chan,['a3Dvert_',filename],pathnames2);
            sav2csv(chan1,['aflat_',filename],pathnames2);
            at_out5 = vertcat(at_out5,t_tmp);
            %save to ndata
            ndata5(j).arotpivots = chan;
            ndata5(j).aflatpivots = chan1;
        end
    end
end
close(h1);
delete(gcp('nocreate'))

%save terminal output
%[t_out] = rmv_duplicate(t_out,[1 2 3]);     %remove duplicates...does not apply here, but remember collapse!
%Class1
t_out = unique(t_out,'rows');
ndata(1).termipivots = t_out;
sav2csv(t_out,'rotated_termini',pathnames12);
at_out = unique(at_out,'rows');
ndata(1).atermipivots = at_out;
sav2csv(at_out,'arotated_termini',pathnames12);
%Class21
t_out2 = unique(t_out2,'rows');
ndata2(1).termipivots = t_out2;
sav2csv(t_out2,'rotated_termini',pathnames21);
at_out2 = unique(at_out2,'rows');
ndata2(1).atermipivots = at_out2;
sav2csv(at_out2,'arotated_termini',pathnames21);
%Class32
t_out3 = unique(t_out3,'rows');
ndata3(1).termipivots = t_out3;
sav2csv(t_out3,'rotated_termini',pathnames32);
at_out3 = unique(at_out3,'rows');
ndata3(1).atermipivots = at_out3;
sav2csv(at_out3,'arotated_termini',pathnames32);
%Class21
t_out4 = unique(t_out4,'rows');
ndata4(1).termipivots = t_out4;
sav2csv(t_out4,'rotated_termini',pathnames23);
at_out4 = unique(at_out4,'rows');
ndata4(1).atermipivots = at_out4;
sav2csv(at_out4,'arotated_termini',pathnames23);
%Class1&2
t_out5 = unique(t_out5,'rows');
ndata5(1).termipivots = t_out5;
sav2csv(t_out5,'rotated_termini',pathnames2);
at_out5 = unique(at_out5,'rows');
ndata5(1).atermipivots = at_out5;
sav2csv(at_out5,'arotated_termini',pathnames2);
%localization for macs
if ispc
    slash = '\';        %Windows directory marker
else
    slash = '/';        %Mac directory marker
end
%Class1
save([pathnames12,slash,'ndata.mat'],'ndata');      %save ndata as well
%Class21
save([pathnames21,slash,'ndata2.mat'],'ndata2');      %save ndata as well
%Class32
save([pathnames32,slash,'ndata3.mat'],'ndata3');      %save ndata as well
%Class23
save([pathnames23,slash,'ndata4.mat'],'ndata4');      %save ndata as well
%Class1&2
save([pathnames2,slash,'ndata5.mat'],'ndata5');      %save ndata as well

%--------------------------------------------------------------------------
function [chan,t_out,o_out,flprot_idx] = syn_align_loco(ori,termi,third)
%Translate all the points first
o_tmp = zeros(size(ori,1),3); %translate ori to 0,0,0.  This is assuming that all vertices are positive, which for an image should be true.
t_tmp = termi(:,1:3)-ori(:,1:3);    %translate termi

%*********************Randomize the associations***************************
rand_ord = [rand(size(ori,1),1) ori(:,4)];     %create a mashup of ordinal and random ordinals
rand_ord = sortrows(rand_ord);  %shuffle the ordinal order
ori(:,4) = rand_ord(:,2);   %put back into the matrix.

%translate third
parfor j = 1:size(ori,1)
    curr_cell = third{ori(j,4)};    %find the current cell in the third channel.  Use the ordinals to pick the cell
    c_tmp{j,1} = curr_cell(:,1:3)-repmat(ori(j,1:3),size(curr_cell,1),1);       %translate channels
end

%fix one last thing, rotate all negative x's to positive, 180 flip,
%because we are enforcing directionality
flpx_idx = t_tmp(:,1)<0;   %create the flip index: 1 will flip and 0 will not
flpx_mtrx = ones(size(t_tmp,1),1);     %create flip matrix for x
flpx_mtrx(flpx_idx,:) = -1;
%modify termial point
t_tmp(:,1) = t_tmp(:,1).*flpx_mtrx;
t_tmp(:,2) = t_tmp(:,2).*flpx_mtrx;     %y is flipped as well for a 180 turn
%modify channel points (third points)
parfor m = 1:size(c_tmp,1)
    c_tmp{m,1}(:,1) = c_tmp{m,1}(:,1)*flpx_mtrx(m,1);      %rotate 180deg x
    c_tmp{m,1}(:,2) = c_tmp{m,1}(:,2)*flpx_mtrx(m,1);      %rotate 180deg y
end

%Now calculate the angle of rotation on the x axis
%calculate vector 1, ori - termi  rotated
v1 = horzcat(hypot(t_tmp(:,1),t_tmp(:,2)),zeros(size(t_tmp,1),1));   %rotating the syn axis to x 0, everything will be aligned to the y axis
v2 = t_tmp(:,[1 2]);      %the origial 
parfor m = 1:size(v1,1)    %calculate the dot product for each pair of vectors
    x_rot(m,1) = dot(v2(m,:),v1(m,:));     %calculate the dot product, which gives us the cos of the angle
end
%x_rot = acos(x_rot./(hypot(v1(:,1),v1(:,2)).*hypot(v2(:,1),v2(:,2)))).*180/pi;        %calculate the angles in degress.
x_rot = acosd(single(x_rot)./single(hypot(v1(:,1),v1(:,2)).*hypot(v2(:,1),v2(:,2))));        %calculate the angles in degress.
%find the clockwise rotations
neg_idx = ones(size(t_tmp,1),1);           %start the index
neg_idx(t_tmp(:,2)>0) = -1;        %clockwise rotation is -degree angle of rotation
%modify rotation angles
x_rot = x_rot.*neg_idx;         %clockwise and counter clockwise set.
%rotate the base vector
parfor m = 1:size(x_rot,1)
    x_tmp(m,:) = ([cosd(x_rot(m,1)),-sind(x_rot(m,1));sind(x_rot(m,1)),cosd(x_rot(m,1))]*[t_tmp(m,1);t_tmp(m,2)])';
end
t_tmp(:,1) = x_tmp(:,1);
%calculte the angle of roation on the z axis
v3 = horzcat(hypot(t_tmp(:,1),t_tmp(:,3)),zeros(size(t_tmp,1),1));   %rotating the syn axis to z 0
v4 = t_tmp(:,[1 3]);      %the origial vector
parfor n = 1:size(v1,1)        %Dot product per pair of vectors
    z_rot(n,1) = dot(v4(n,:),v3(n,:));     %calculate the dot product, which gives us the cos of the angle
end
%z_rot = acos(z_rot./(hypot(v3(:,1),v3(:,2)).*hypot(v4(:,1),v4(:,2)))).*180/pi;        %calculate the angles in degress.
z_rot = acosd(single(z_rot)./single(hypot(v3(:,1),v3(:,2)).*hypot(v4(:,1),v4(:,2))));        %calculate the angles in degress.
%find the clockwise rotations
neg_idx = ones(size(t_tmp,1),1);           %start the index
neg_idx(t_tmp(:,3)>0) = -1;        %clockwise rotation is -degree angle of rotation
%modify rotation angles
z_rot = z_rot.*neg_idx;         %clockwise and counter clockwise set.

%now rotate the third points
chan = [];      %initialize
%h = waitbar(0,'Rotating Vector: 0');    %initialize progress bar.
parfor k = 1:size(c_tmp,1)
    %waitbar(k/size(c_tmp,1),h,['Rotating Vector: ' num2str(k)]);   %update progress
    curr_cell = c_tmp{k,1};    %find the current cell in the third channel. 
    for l = 1:size(curr_cell,1)     %go through the vertices
        rotx_tmp = [cosd(x_rot(k,1)),-sind(x_rot(k,1));sind(x_rot(k,1)),cosd(x_rot(k,1))]*curr_cell(l,[1 2])';    %rotation in x plane
        rotz_tmp = [cosd(z_rot(k,1)),-sind(z_rot(k,1));sind(z_rot(k,1)),cosd(z_rot(k,1))]*[rotx_tmp(1) curr_cell(l,3)]';    %more acurate for x, but not z???
        chan_tmp(l,:) = [rotz_tmp(1) rotx_tmp(2) rotz_tmp(2)];        %store new rotated vertex.
    end
    chan_tmp(isnan(chan_tmp)) = 0;      %Nan is 0
    chan = vertcat(chan,chan_tmp);      %create the rotated third channel, we no longer need the structure of c_tmp or ori or termi, unbound.
    chan_tmp = [];
end
%close(h);   %close progress bar

%output termi and ori
if size(termi,2)==3     %no extra data, just the vertex
    t_out = [hypot(t_tmp(:,1),hypot(t_tmp(:,2),t_tmp(:,3))),zeros(size(t_tmp,1),2)];
    o_out = o_tmp;
else                    %extra data, concatenate into the matrix
    t_out = horzcat([t_tmp(:,1),zeros(size(t_tmp,1),1),t_tmp(:,3)],termi(:,end-(size(termi,2)-3):end));
    o_out = horzcat(o_tmp,ori(:,end-(size(ori,2)-3):end));
end
%output flprot_idx
flprot_idx = [flpx_idx x_rot z_rot];